package com.example.statemachine.exception.handling;

import org.springframework.statemachine.StateContext;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
final class ExceptionHandlingAction {

	static void execute(final StateContext<?, ?> stateContext) {
		ExtendedStateExceptionAccessor.addException(stateContext.getException(), stateContext.getExtendedState());
	}
}