package com.example.statemachine.exception.handling;

import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.NonNull;

@AllArgsConstructor(access = AccessLevel.PRIVATE)
final class ExceptionHandlingGuardWrapper<S, E> implements Guard<S, E> {

	@NonNull
	private final Guard<S, E> guard;

	@Override
	public boolean evaluate(final StateContext<S, E> context) {
		try {
			return guard.evaluate(context);
		} catch (final Throwable e) {
			ExtendedStateExceptionAccessor.addException(e, context.getExtendedState());
			throw e;
		}
	}

	static <S, E> Guard<S, E> wrap(final Guard<S, E> guard) {
		return new ExceptionHandlingGuardWrapper<>(guard);
	}
}