package com.example.statemachine.exception.handling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

import org.springframework.statemachine.ExtendedState;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
final class ExtendedStateExceptionAccessor {

	private static final String EXCEPTIONS_KEY = ExtendedStateExceptionAccessor.class.getName() + "_EXCEPTIONS";

	// only this class sets / gets exceptions attribute
	@SuppressWarnings("unchecked")
	static void addException(final Throwable exception, final ExtendedState extendedState) {

		Collection<Throwable> exceptions = extendedState.get(EXCEPTIONS_KEY, Collection.class);

		if (exceptions == null) {
			exceptions = new ArrayList<>();
			extendedState.getVariables().put(EXCEPTIONS_KEY, exceptions);
		}
		exceptions.add(exception);
	}

	// see above
	@SuppressWarnings("unchecked")
	static List<Throwable> getExceptions(final ExtendedState extendedState) {
		return Optional.ofNullable(extendedState.get(EXCEPTIONS_KEY, List.class))
				.orElseGet(List::of);
	}
}